% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.project.R
\name{opal.project_backup}
\alias{opal.project_backup}
\title{Backup a project}
\usage{
opal.project_backup(
  opal,
  project,
  archive,
  viewsAsTables = FALSE,
  override = TRUE,
  wait = TRUE
)
}
\arguments{
\item{opal}{Opal object.}

\item{project}{Name of the project.}

\item{archive}{Archive directory path in the Opal file system. If folder (and parents) does not exist, it will be created.}

\item{viewsAsTables}{Treat views as tables, i.e. export data instead of keeping derivation scripts. Default is FALSE.}

\item{override}{Overwrite an existing backup folder. Default is TRUE.}

\item{wait}{Wait for backup task completion. Default is TRUE.}
}
\value{
The project command ID if wait parameter is FALSE. See \link{opal.project_command} to retrieve asynchronous command state.
}
\description{
The project backup task has a limited scope: tables (dictionary and data export), 
views (either as a logical table or as an exported table), resources, files and report 
templates. Other project elements that are not part of the backup: user and group 
permissions, view change history, table analysis, report executions etc.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.project_backup(o, 'GREENSPACE', '/home/administrator/backup/GREENSPACE')
opal.file_download(o, '/home/administrator/backup/GREENSPACE', 'GREENSPACE.zip')
opal.logout(o)
}
}
