/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;
import opennlp.tools.coref.resolver.ResolverUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingularPronounResolver
extends MaxentResolver {
    int mode;
    Pattern PronounPattern;

    public SingularPronounResolver(String projectName, ResolverMode m) throws IOException {
        super(projectName, "pmodel", m, 30);
        this.numSentencesBack = 2;
    }

    public SingularPronounResolver(String projectName, ResolverMode m, NonReferentialResolver nonReferentialResolver) throws IOException {
        super(projectName, "pmodel", m, 30, nonReferentialResolver);
        this.numSentencesBack = 2;
    }

    @Override
    public boolean canResolve(MentionContext mention) {
        String tag = mention.getHeadTokenTag();
        return tag != null && tag.startsWith("PRP") && ResolverUtils.singularThirdPersonPronounPattern.matcher(mention.getHeadTokenText()).matches();
    }

    @Override
    protected List<String> getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList<String> features = new ArrayList<String>();
        features.addAll(super.getFeatures(mention, entity));
        if (entity != null) {
            MentionContext cec = entity.getLastExtent();
            features.addAll(ResolverUtils.getPronounMatchFeatures(mention, entity));
            features.addAll(ResolverUtils.getContextFeatures(cec));
            features.addAll(ResolverUtils.getDistanceFeatures(mention, entity));
            features.add(ResolverUtils.getMentionCountFeature(entity));
        }
        return features;
    }

    @Override
    public boolean excluded(MentionContext mention, DiscourseEntity entity) {
        if (super.excluded(mention, entity)) {
            return true;
        }
        String mentionGender = null;
        Iterator<MentionContext> ei = entity.getMentions();
        while (ei.hasNext()) {
            String entityGender;
            MentionContext entityMention = ei.next();
            String tag = entityMention.getHeadTokenTag();
            if (tag == null || !tag.startsWith("PRP") || !ResolverUtils.singularThirdPersonPronounPattern.matcher(mention.getHeadTokenText()).matches()) continue;
            if (mentionGender == null) {
                mentionGender = ResolverUtils.getPronounGender(mention.getHeadTokenText());
            }
            if ((entityGender = ResolverUtils.getPronounGender(entityMention.getHeadTokenText())).equals("u") || mentionGender.equals(entityGender)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean outOfRange(MentionContext mention, DiscourseEntity entity) {
        MentionContext cec = entity.getLastExtent();
        return mention.getSentenceNumber() - cec.getSentenceNumber() > this.numSentencesBack;
    }
}

