% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_answer.R
\name{create_answer}
\alias{create_answer}
\title{Create answer}
\usage{
create_answer(
  model = c("ada", "babbage", "curie", "davinci"),
  question,
  examples,
  examples_context,
  documents = NULL,
  file = NULL,
  search_model = c("ada", "babbage", "curie", "davinci"),
  max_rerank = 200,
  temperature = 0,
  logprobs = NULL,
  max_tokens = 16,
  stop = NULL,
  n = 1,
  logit_bias = NULL,
  return_metadata = FALSE,
  return_prompt = FALSE,
  expand = NULL,
  user = NULL,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{model}{required; defaults to \code{"ada"}; a length one character vector,
one among \code{"ada"}, \code{"babbage"}, \code{"curie"}, and \code{"davinci"}.}

\item{question}{required; a length one character vector.}

\item{examples}{required; a list.}

\item{examples_context}{required; a length one character vector.}

\item{documents}{optional; defaults to \code{NULL}; an arbitrary length character
vector.}

\item{file}{optional; defaults to \code{NULL}; a length one character vector.}

\item{search_model}{required; defaults to \code{ada}; a length one character
vector, one among \code{"ada"}, \code{"babbage"}, \code{"curie"}, and \code{"davinci"}.}

\item{max_rerank}{required; defaults to \code{200}; a length one numeric vector
with the integer value greater than \code{0}.}

\item{temperature}{required; defaults to \code{0}; a length one numeric vector
with the value between \code{0} and \code{2}.}

\item{logprobs}{optional; defaults to \code{NULL}; a length one numeric vector
with the integer value between \code{0} and \code{5}.}

\item{max_tokens}{required; defaults to \code{16}; a length one numeric vector
with the integer value greater than \code{0}.}

\item{stop}{optional; defaults to \code{NULL}; a character vector of length
between one and four.}

\item{n}{required; defaults to \code{1}; a length one numeric vector with the
integer value greater than \code{0}.}

\item{logit_bias}{optional; defaults to \code{NULL}; a named list.}

\item{return_metadata}{required; defaults to \code{FALSE}; a length one logical
vector.}

\item{return_prompt}{required; defaults to \code{FALSE}; a length one logical
vector.}

\item{expand}{optional; defaults to \code{NULL}; a list elements of which are
among \code{completion} and \code{file}.}

\item{user}{optional; defaults to \code{NULL}; a length one character vector.}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, elements of which contain an answer and other
supplementary information.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\strong{Note:} This endpoint is deprecated and will be removed on December 3,
2022. Please see \href{https://help.openai.com/en/articles/6233728-answers-transition-guide}{Answers Transition Guide}
for details.

Answers the specified question based on the documents and examples. See
\href{https://beta.openai.com/docs/api-reference/answers/create}{this page} for
details.
}
\details{
For arguments description please refer to the \href{https://beta.openai.com/docs/api-reference/answers/create}{official documentation}.
}
\examples{
\dontrun{
create_answer(
    search_model = "ada",
    model = "curie",
    question = "How many red apples do I have?",
    documents = c("I have five green apples.", "I love oranges."),
    examples_context = "Jack has three brothers and one sister. His sister is sad",
    examples = list(
        c("How many siblings has Jack?", "Three"),
        c("Who is sad?", "Jack's sister is.")
    ),
    max_tokens = 5,
    stop = c("\n", "<|endoftext|>"),
)
}
}
