% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_classification.R
\name{create_classification}
\alias{create_classification}
\title{Create classification}
\usage{
create_classification(
  model = c("ada", "babbage", "curie", "davinci"),
  query,
  examples = NULL,
  file = NULL,
  labels = NULL,
  search_model = c("ada", "babbage", "curie", "davinci"),
  temperature = 0,
  logprobs = NULL,
  max_examples = 200,
  logit_bias = NULL,
  return_prompt = FALSE,
  return_metadata = FALSE,
  expand = NULL,
  user = NULL,
  openai_api_key = Sys.getenv("OPENAI_API_KEY"),
  openai_organization = NULL
)
}
\arguments{
\item{model}{required; defaults to \code{"ada"}; a length one character vector,
one among \code{"ada"}, \code{"babbage"}, \code{"curie"}, and \code{"davinci"}.}

\item{query}{required; a length one character vector.}

\item{examples}{optional; defaults to \code{NULL}; a list. A list of examples with
labels, in the following format: \code{list(c("The movie is so interesting.", "Positive"), c("It is quite boring.", "Negative"), ...)}.}

\item{file}{optional; defaults to \code{NULL}; a length one character vector.}

\item{labels}{optional; defaults to \code{NULL}; an arbitrary length character
vector.}

\item{search_model}{required; defaults to \code{ada}; a length one character
vector, one among \code{"ada"}, \code{"babbage"}, \code{"curie"}, and \code{"davinci"}.}

\item{temperature}{required; defaults to \code{0}; a length one numeric vector
with the value between \code{0} and \code{2}.}

\item{logprobs}{optional; defaults to \code{NULL}; a length one numeric vector
with the integer value between \code{0} and \code{5}.}

\item{max_examples}{required; defaults to \code{200}; a length one numeric vector
with the integer value greater than \code{0}.}

\item{logit_bias}{optional; defaults to \code{NULL}; a named list.}

\item{return_prompt}{required; defaults to \code{FALSE}; a length one logical
vector.}

\item{return_metadata}{required; defaults to \code{FALSE}; a length one logical
vector.}

\item{expand}{optional; defaults to \code{NULL}; a list elements of which are
among \code{completion} and \code{file}.}

\item{user}{optional; defaults to \code{NULL}; a length one character vector.}

\item{openai_api_key}{required; defaults to \code{Sys.getenv("OPENAI_API_KEY")}
(i.e., the value is retrieved from the \code{.Renviron} file); a length one
character vector. Specifies OpenAI API key.}

\item{openai_organization}{optional; defaults to \code{NULL}; a length one
character vector. Specifies OpenAI organization.}
}
\value{
Returns a list, elements of which contain label and other
supplementary information.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\strong{Note:} This endpoint is deprecated and will be removed on December 3,
2022. Please see \href{https://help.openai.com/en/articles/6272941-classifications-transition-guide}{Classifications Transition Guide}
for details.

Classifies the query based on the provided examples. See \href{https://beta.openai.com/docs/api-reference/classifications/create}{this page}
for details.
}
\details{
For arguments description please refer to the \href{https://beta.openai.com/docs/api-reference/classifications/create}{official documentation}.
}
\examples{
\dontrun{
create_classification(
    search_model = "ada",
    model = "curie",
    examples = list(
        c("A happy moment", "Positive"),
        c("I am sad.", "Negative"),
        c("I am feeling awesome", "Positive")
    ),
    query = "I'm ok",
    labels = c("Positive", "Negative", "Neutral")
)
}
}
