\name{rollingMean}
\alias{rollingMean}
\title{Calculate rollingMean values}
\usage{
rollingMean(mydata, pollutant = "o3", width = 8, new.name = "rolling",
  data.thresh = 75, align = "centre", ...)
}
\arguments{
  \item{mydata}{A data frame containing a \code{date}
  field. \code{mydata} must contain a \code{date} field in
  \code{Date} or \code{POSIXct} format. The input time
  series must be regular e.g. hourly, daily.}

  \item{pollutant}{The name of a pollutant e.g.
  \code{pollutant = "o3"}.}

  \item{width}{The averaging period (rolling window width)
  to use e.g. \code{width = 8} will generate 8-hour rolling
  mean values when hourly data are analysed.}

  \item{new.name}{The name given to the new rollingMean
  variable. If not supplied it will create a name based on
  the name of the pollutant and the averaging period used.}

  \item{data.thresh}{The data capture threshold in %. No
  values are calculated if data capture over the period of
  interest is less than this value. For example, with
  \code{width = 8} and \code{data.thresh = 75} at least 6
  hours are required to calculate the mean, else \code{NA}
  is returned.}

  \item{align}{specifyies how the moving window should be
  aligned. \code{"right"} means that the previous
  \code{hours} (including the current) are averaged. This
  seems to be the default for UK air quality rolling mean
  statistics. \code{"left"} means that the forward
  \code{hours} are averaged, and \code{"centre"} or
  \code{"center"}, which is the default.}

  \item{...}{other arguments, currently unused.}
}
\description{
Calculate rollingMean values taking account of data capture
thresholds
}
\details{
This is a utility function mostly designed to calculate
rolling mean statistics relevant to some pollutant limits
e.g. 8 hour rolling means for ozone and 24 hour rolling
means for PM10. However, the function has a more general
use in helping to display rolling mean values in flexible
ways e.g. with the rolling window width left, right or
centre aligned.

The function will try and fill in missing time gaps to get
a full time sequence but return a data frame with the same
number of rows supplied.
}
\examples{
## rolling 8-hour mean for ozone
mydata <- rollingMean(mydata, pollutant = "o3", width = 8, new.name =
"rollingo3", data.thresh = 75, align = "right")
}
\author{
David Carslaw
}
\keyword{methods}

