% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{models}
\alias{models}
\title{Models Class}
\description{
Models Class

Models Class
}
\section{Super class}{
\code{\link[openaistream:openai]{openaistream::openai}} -> \code{models}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-models-list}{\code{models$list()}}
\item \href{#method-models-retrieve}{\code{models$retrieve()}}
\item \href{#method-models-delete}{\code{models$delete()}}
\item \href{#method-models-clone}{\code{models$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="openaistream" data-topic="openai" data-id="initialize"><a href='../../openaistream/html/openai.html#method-openai-initialize'><code>openaistream::openai$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-models-list"></a>}}
\if{latex}{\out{\hypertarget{method-models-list}{}}}
\subsection{Method \code{list()}}{
Lists the currently available models, and provides basic information
             about each one such as the owner and availability.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{models$list(verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of model objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-models-retrieve"></a>}}
\if{latex}{\out{\hypertarget{method-models-retrieve}{}}}
\subsection{Method \code{retrieve()}}{
Retrieves a model instance, providing basic information about
             the model such as the owner and permissioning.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{models$retrieve(model, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{character Required. The ID of the model to use for this request}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The model object matching the specified ID.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-models-delete"></a>}}
\if{latex}{\out{\hypertarget{method-models-delete}{}}}
\subsection{Method \code{delete()}}{
Delete a fine-tuned model. You must have the Owner role in
             your organization to delete a model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{models$delete(model, verbosity = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{character Required. The model to delete}

\item{\code{verbosity}}{numeric. Verbosity level for the API call(0:no output;1:show headers;
2:show headers and bodies;3: show headers, bodies, and curl status messages.).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Deletion status.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-models-clone"></a>}}
\if{latex}{\out{\hypertarget{method-models-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{models$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
