% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oaVenues2df.R
\name{oaVenues2df}
\alias{oaVenues2df}
\title{Convert OpenAlex collection of venues' records from list format to data frame}
\usage{
oaVenues2df(data, verbose = TRUE)
}
\arguments{
\item{data}{is a list. data is the output of the function \code{oa_request}.}

\item{verbose}{is a logical. If TRUE, information about the querying process will be plotted on screen. Default is \code{verbose=TRUE}.}
}
\value{
a data.frame.

For more extensive information about OpenAlex API, please visit: \href{https://docs.openalex.org/api}{https://docs.openalex.org/api}
}
\description{
It converts bibliographic collection of venues' records gathered from OpenAlex database \href{https://openalex.org/}{https://openalex.org/} into data frame.
The function converts a list of venues' records obtained using \code{oa_request} into a data frame/tibble.
}
\examples{
\dontrun{

# Query to search information about the Journal of Informetrics (OA id:V205292342)


query_inst <- oa_query(
  identifier = "V205292342",
  entity = "venues"
)

res <- oa_request(
  query_url = query_inst,
  count_only = FALSE,
  verbose = FALSE
)

df <- oa2df(res, entity = "venues")

df
}

# @export
}
