% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oa_snowball.R
\name{oa_snowball}
\alias{oa_snowball}
\title{A function to perform a snowball search
and convert the result to a tibble/data frame.}
\usage{
oa_snowball(
  identifier = NULL,
  ...,
  id_type = c("short", "original"),
  mailto = oa_email(),
  endpoint = "https://api.openalex.org",
  verbose = FALSE,
  citing_params = list(),
  cited_by_params = list()
)
}
\arguments{
\item{identifier}{Character vector of openalex identifiers.}

\item{...}{Additional arguments to pass to `oa_fetch` when querying the
input works, such as `doi`.}

\item{id_type}{Type of OpenAlex IDs to return. Defaults to "short",
which remove the prefix https://openalex.org/ in the works' IDs,
for example, W2755950973.
If "original", the OpenAlex IDs are kept as are,
for example, https://openalex.org/W2755950973}

\item{mailto}{Character string.
Gives OpenAlex an email to enter the polite pool.}

\item{endpoint}{Character. URL of the OpenAlex Endpoint API server.
Defaults to endpoint = "https://api.openalex.org".}

\item{verbose}{Logical. If TRUE, print information on querying process.
Default to \code{verbose = FALSE}.
To shorten the printed query URL, set the environment variable openalexR.print
to the number of characters to print: \code{Sys.setenv(openalexR.print = 70)}.}

\item{citing_params}{parameters used in the search of works citing the input works.}

\item{cited_by_params}{parameters used in the search of works cited by the input works.}
}
\value{
A list containing 2 elements:
- nodes: dataframe with publication records.
The last column `oa_input` indicates whether the work was
one of the input `identifier`(s).
- edges: publication link dataframe of 2 columns `from, to`
such that a row `A, B` means A -> B means A cites B.
In bibliometrics, the "citation action" comes from A to B.
}
\description{
A function to perform a snowball search
and convert the result to a tibble/data frame.
}
\examples{
\dontrun{

snowball_docs <- oa_snowball(
  identifier = c("W2741809807", "W2755950973"),
  citing_params = list(from_publication_date = "2022-01-01"),
  cited_by_params = list(),
  verbose = TRUE
)
}
}
