% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oc_event_publication.R
\name{oc_event_publication}
\alias{oc_event_publication}
\title{Query Opencast for a specific events single publication}
\usage{
oc_event_publication(eventId = "", publicationId = "", sign = FALSE)
}
\arguments{
\item{eventId}{The event id}

\item{publicationId}{The publication id}

\item{sign}{Whether public distribution urls should be signed.}
}
\value{
Returns a single publication.
}
\description{
Returns a single publication.
}
\details{
This function expects the hostname, username and password to be set as environment variables.
}
\examples{
Sys.setenv(OPENCAST_HOST = "https://legacy.opencast.org")
Sys.setenv(OPENCAST_USERNAME = "admin")
Sys.setenv(OPENCAST_PASSWORD = "opencast")

events <- oc_list_events()
publications <- oc_event_list_publications(events$content$identifier[1])

oc_event_publication(events$content$identifier[1],
                     publications$content$id[1])
}
