% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_graph_building.R
\name{Graph}
\alias{Graph}
\title{Graph object}
\value{
Object of \code{\link[R6:R6Class]{R6::R6Class()}} with methods for building an openEO process graph
}
\description{
This class represents an openEO process graph - which is generally denoted as field \code{process_graph}
in the exchange objects of the API. The graph consists of \code{\link[=ProcessNode]{ProcessNode()}}s and optional
\code{\link[=ProcessGraphParameter]{ProcessGraphParameter()}} (former variables). The explicit creation of a Graph is usually not
required and discouraged, because this will be handled automatically.
}
\details{
In terms of the openEO API the process graph is the technical description of a process. To create a
user-defined process it requires a process graph and additional meta data. The process graph is not
accepted at any openEO endpoint directly. Therefore, it has to be wrapped in a \code{\link[=Process]{Process()}}
object. Use \code{\link[=as.Process]{as.Process()}} in those cases. It is similarly handled in other functions of
this package.
}
\section{Fields}{

\describe{
\item{\code{data}}{a named list of collection ids or process graph parameters depending on the context}
}}

\section{Methods}{

\describe{
\item{\verb{$new(final_node=NULL)}}{The object creator created from processes and available data.}
\item{\verb{$getNodes()}}{a function to return a list of created \code{\link[=ProcessNode]{ProcessNode()}}s for this graph}
\item{\verb{$serialize()}}{creates a list representation of the graph by recursively calling \verb{$serialize}}
\item{\verb{$validate()}}{runs through the nodes and checks the validity of its argument values}
\item{\verb{$getNode(node_id)}}{searches and returns a node from within the graph referenced by its node id}
\item{\verb{$addNode(node)}}{adds a \code{\link[=ProcessNode]{ProcessNode()}} to the graph}
\item{\verb{$removeNode(node_id)}}{removes a process node from the graph}
\item{\verb{$getFinalNode()}}{gets the result process node of a process graph}
\item{\verb{$setFinalNode(node)}}{sets the result process node by node id or a ProcessNode}
\item{\verb{$getVariables()}}{creates a named list of the defined variables of a process graph}
\item{\verb{$setVariables(list_of_vars)}}{sets the \code{\link[=ProcessGraphParameter]{ProcessGraphParameter()}} ( former variables) of graph}
}
}

\section{Arguments}{

\describe{
\item{\code{final_node}}{optional, the final node (end node) that was used to create a graph}
\item{\code{node_id}}{the id of a process node}
\item{\code{node}}{process node or  its node id}
\item{\code{parameter}}{the name of a parameter in a process}
\item{\code{value}}{the value to be set for a parameter of a particular process}
\item{\code{id} or \code{variable_id}}{the variable id}
\item{\code{description}}{a description field for a variable}
\item{\code{type}}{the type of variable, default 'string'}
\item{\code{default}}{optional default value to be set for a variable}
}
}

