% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oms-UpdateModelWorkset.R
\name{set_workset_readonly}
\alias{set_workset_readonly}
\alias{new_workset}
\alias{merge_workset}
\alias{update_workset_param_csv}
\alias{replace_workset}
\alias{delete_workset}
\alias{delete_scenario}
\alias{delete_workset_param}
\alias{update_workset_param}
\alias{copy_param_run_to_workset}
\alias{merge_param_run_to_workset}
\alias{copy_param_workset_to_workset}
\alias{merge_param_workset_to_workset}
\alias{upload_workset_params}
\title{Update Workset Metadata}
\usage{
set_workset_readonly(model, set, readonly)

new_workset(data)

merge_workset(workset)

update_workset_param_csv(workset, csv)

replace_workset(workset)

delete_workset(model, set)

delete_scenario(model, set)

delete_workset_param(model, set, name)

update_workset_param(model, set, name, data)

copy_param_run_to_workset(model, set, name, run)

merge_param_run_to_workset(model, set, name, run)

copy_param_workset_to_workset(model, set, name, from)

merge_param_workset_to_workset(model, set, name, from)

upload_workset_params(model, set, data)
}
\arguments{
\item{model}{Model digest or model name.}

\item{set}{Name of workset (input set of model parameters).}

\item{readonly}{Boolean. Should workset be read-only?}

\item{data}{Data used for the body of the request.}

\item{workset}{Workset metadata.}

\item{csv}{CSV file path.}

\item{name}{Output table name.}

\item{run}{Model run digest, run stamp or run name, modeling task run
stamp or task run name.}

\item{from}{Source workset name.}
}
\value{
A \code{list}, \code{tibble}, or nothing (invisibly).
}
\description{
Functions for creating, copying, merging, retrieving, and deleting
worksets. More information about these API endpoints can be found at
\href{https://github.com/openmpp/openmpp.github.io/wiki/Oms-web-service-API#update-model-workset-set-of-input-parameters}{here}.
}
\examples{
\dontrun{
use_OpenMpp_local()
set_workset_readonly("RiskPaths", "Default", TRUE)
}

}
