% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_chartsheet}
\alias{wb_add_chartsheet}
\title{Add a chartsheet to a workbook}
\usage{
wb_add_chartsheet(
  wb,
  sheet = next_sheet(),
  tab_color = NULL,
  zoom = 100,
  visible = c("true", "false", "hidden", "visible", "veryhidden"),
  ...
)
}
\arguments{
\item{wb}{A Workbook object to attach the new worksheet}

\item{sheet}{A name for the new worksheet}

\item{tab_color}{Color of the worksheet tab. A valid color (belonging to
colors()) or a valid hex color beginning with "#"}

\item{zoom}{A numeric between 10 and 400. Worksheet zoom level as a
percentage.}

\item{visible}{If FALSE, sheet is hidden else visible.}

\item{...}{...}
}
\description{
Add a chartsheet to a workbook
}
\details{
After chartsheet creation a chart must be added to the sheet.
Otherwise the chartsheet will break the workbook.
}
\seealso{
\code{\link[=wb_add_mschart]{wb_add_mschart()}}

Other workbook wrappers: 
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_base_font}},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_col_widths}},
\code{\link{wb_copy_cells}()},
\code{\link{wb_creators}},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_grouping}},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_set_row_heights}()},
\code{\link{wb_workbook}()}
}
\concept{workbook wrappers}
