% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{col_widths-wb}
\alias{col_widths-wb}
\alias{wb_set_col_widths}
\alias{wb_remove_col_widths}
\title{Modify column widths of a worksheet}
\usage{
wb_set_col_widths(
  wb,
  sheet = current_sheet(),
  cols,
  widths = 8.43,
  hidden = FALSE
)

wb_remove_col_widths(wb, sheet = current_sheet(), cols)
}
\arguments{
\item{wb}{A \code{wbWorkbook} object.}

\item{sheet}{A name or index of a worksheet, a vector in the case of \code{remove_}}

\item{cols}{Indices of cols to set/remove column widths.}

\item{widths}{Width to set \code{cols} to specified column width or \code{"auto"} for
automatic sizing. \code{widths} is recycled to the length of \code{cols}. openxlsx2
sets the default width is 8.43, as this is the standard in some spreadsheet
software. See \strong{Details} for general information on column widths.}

\item{hidden}{Logical vector recycled to the length of \code{cols}.
If \code{TRUE}, the columns are hidden.}
}
\description{
Remove / set worksheet column widths to specified width or "auto".
}
\details{
The global min and max column width for "auto" columns is set by (default values show):
\itemize{
\item \code{options("openxlsx2.minWidth" = 3)}
\item \code{options("openxlsx2.maxWidth" = 250)} Maximum width allowed in Excel
}

NOTE: The calculation of column widths can be slow for large worksheets.

NOTE: The \code{hidden} parameter may conflict with the one set in \code{\link[=wb_group_cols]{wb_group_cols()}};
changing one will update the other.

NOTE: The default column width varies by spreadsheet software, operating system,
and DPI settings used. Setting \code{widths} to specific value also is no guarantee
that the output will have consistent column widths.

For automatic text wrapping of columns use
\link[=wb_add_cell_style]{wb_add_cell_style(wrap_text = TRUE)}
}
\examples{
## Create a new workbook
wb <- wb_workbook()

## Add a worksheet
wb$add_worksheet("Sheet 1")

## set col widths
wb$set_col_widths(cols = c(1, 4, 6, 7, 9), widths = c(16, 15, 12, 18, 33))

## auto columns
wb$add_worksheet("Sheet 2")
wb$add_data(sheet = 2, x = iris)
wb$set_col_widths(sheet = 2, cols = 1:5, widths = "auto")

## removing column widths
## Create a new workbook
wb <- wb_load(file = system.file("extdata", "openxlsx2_example.xlsx", package = "openxlsx2"))

## remove column widths in columns 1 to 20
wb_remove_col_widths(wb, 1, cols = 1:20)
}
\seealso{
Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_base_colors}},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}

Other worksheet content functions: 
\code{\link{filter-wb}},
\code{\link{grouping-wb}},
\code{\link{named_region-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_conditional_formatting}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_thread}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()}
}
\concept{workbook wrappers}
\concept{worksheet content functions}
