% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_loss.R
\name{check_loss}
\alias{check_loss}
\title{Function to check validy of provided loss function}
\usage{
check_loss(
  loss.type,
  loss.gradient,
  Y = NULL,
  model = NULL,
  use_cpp = getOption("opera_use_cpp", default = FALSE)
)
}
\arguments{
\item{loss.type}{\code{character, list or function}. 
\describe{
     \item{character}{ Name of the loss to be applied ('square', 'absolute', 'percentage', or 'pinball');}
     \item{list}{ When using pinball loss: list with field name equal to 'pinball' and field tau equal to the required quantile in [0,1];}
     \item{function}{ A custom loss as a function of two parameters.}
}}

\item{loss.gradient}{\code{boolean, function}. 
\describe{
     \item{boolean}{ If TRUE, the aggregation rule will not be directly applied to the loss function at hand,
     but to a gradient version of it. The aggregation rule is then similar to gradient descent aggregation rule. }
     \item{function}{ If loss.type is a function, the derivative should be provided to be used (it is not automatically 
     computed).}
}}

\item{Y}{\code{numeric} (NULL). (Optional) Target values (to perform some checks).}

\item{model}{\code{character} (NULL). (Optional) Model used (to perform some checks).}

\item{use_cpp}{\code{boolean}. Whether or not to use cpp function to increase perf.}
}
\value{
loss.type
}
\description{
Function to check validy of provided loss function
}
