% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_relative_targets.R
\name{add_relative_targets}
\alias{add_relative_targets}
\alias{add_relative_targets,ProjectProblem,numeric-method}
\alias{add_relative_targets,ProjectProblem,character-method}
\title{Add relative targets}
\usage{
\S4method{add_relative_targets}{ProjectProblem,numeric}(x, targets)

\S4method{add_relative_targets}{ProjectProblem,character}(x, targets)
}
\arguments{
\item{x}{\code{\link{ProjectProblem-class}} object.}

\item{targets}{Object that specifies the targets for each feature. See the
Details section for more information.}
}
\description{
Set targets as a proportion (between 0 and 1) of the maximum probability of
persistence associated with the best project for feature. For instance,
if the best project for a feature has an 80% probability of persisting,
setting a 50\% (i.e. \code{0.5}) relative target will correspond to a 40\%
threshold probability of persisting.
}
\details{
Targets are used to specify the minimum probability of persistence
  for each feature in solutions. For minimum set objectives
  (i.e. \code{\link{add_min_set_objective}}, these targets
  specify the minimum probability of persistence required for each species
  in the solution. And for budget constrained objectives that use targets
  (i.e.\code{\link{add_max_targets_met_objective}}), these targets
  specify the minimum threshold probability of persistence that needs to be
  achieved to count the benefits for conserving these species.
  Please note that attempting to solve problems with objectives that require
  targets without specifying targets will throw an error.

  The targets for a problem can be specified in several different ways:

  \describe{

  \item{\code{numeric}}{\code{vector} of target values for each feature.
    The order of the target values should correspond to the order
    of the features in the data used to create the argument to \code{x}.
    Additionally, for convenience, this type of argument can be a single
    value to assign the same target to each feature.}

  \item{\code{character}}{specifying the name of column in the
    feature data (i.e. the argument to \code{features} in the
    \code{\link{problem}} function) that contains the persistence targets.}

  }
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)

# build problem with minimum set objective and targets that require each
# feature to have a level of persistence that is greater than or equal to
# 70\% of the best project for conserving it
p1 <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(0.7) \%>\%
      add_binary_decisions()

# print problem
print(p1)

# build problem with minimum set objective and specify targets that require
# different levels of persistence for each feature
p2 <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets(c(0.2, 0.3, 0.4, 0.5, 0.6)) \%>\%
      add_binary_decisions()

# print problem
print(p2)

# add a column name to the feature data with targets
sim_features$target <- c(0.2, 0.3, 0.4, 0.5, 0.6)

# build problem with minimum set objective and specify targets using
# column name in the feature data
p3 <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
      add_min_set_objective() \%>\%
      add_relative_targets("target") \%>\%
      add_binary_decisions()

# print problem
print(p3)

# solve problems
s1 <- solve(p1)
s2 <- solve(p2)
s3 <- solve(p3)

# print solutions
print(s1)
print(s2)
print(s3)

# plot solutions
plot(p1, s1)
plot(p2, s2)
plot(p3, s3)

}
\seealso{
\code{\link{targets}}.
}
