% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Solver-proto.R
\name{Solver-class}
\alias{Solver-class}
\alias{Solver}
\title{Solver prototype}
\description{
This prototype is used to generate objects that represent methods for solving
optimization problems. \strong{This class represents a recipe to
create solver and and is only recommended for use by expert users. To
customize the method used to solve optimization problems, please see the
help page on \code{\link{solvers}}}.
}
\section{Fields}{


\describe{

\item{$name}{\code{character} name of solver.}

\item{$parameters}{\code{Parameters} object with parameters used to customize
  the the solver.}

\item{$solve}{\code{function} used to solve a
  \code{\link{OptimizationProblem-class}} object.}
}
}

\section{Usage}{


\code{x$print()}

\code{x$show()}

\code{x$repr()}

\code{x$solve(op)}
}

\section{Arguments}{

\describe{

\item{x}{\code{\link{Solver-class}} object.}

\item{op}{\code{\link{OptimizationProblem-class}} object.}

}
}

\section{Details}{


\describe{
\item{print}{print the object.}

\item{show}{show the object.}

\item{repr}{\code{character} representation of object.}

\item{solve}{solve an \code{\link{OptimizationProblem-class}} using this
  object.}

}
}

