% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_of_features.R
\name{number_of_features}
\alias{number_of_features}
\alias{number_of_features,ProjectProblem-method}
\alias{number_of_features,OptimizationProblem-method}
\title{Number of features}
\usage{
number_of_features(x)

\S4method{number_of_features}{ProjectProblem}(x)

\S4method{number_of_features}{OptimizationProblem}(x)
}
\arguments{
\item{x}{\linkS4class{ProjectProblem} or
\linkS4class{OptimizationProblem} object.}
}
\value{
\code{integer} number of features.
}
\description{
Extract the number of features in an object.
}
\examples{
# load data
data(sim_projects, sim_features, sim_actions)

# build problem with default solver
p <- problem(sim_projects, sim_actions, sim_features,
             "name", "success", "name", "cost", "name") \%>\%
     add_max_richness_objective(budget = 200) \%>\%
     add_binary_decisions() \%>\%
     add_default_solver()

# print problem
print(p)

# print number of features
number_of_features(p)
}
