% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Collection-proto.R
\name{Collection-class}
\alias{Collection-class}
\alias{Collection}
\title{Collection prototype}
\description{
This prototype represents a collection of
\linkS4class{ProjectModifier} objects.
}
\section{Fields}{

\describe{
\item{$...}{\linkS4class{ProjectModifier} objects stored
in the collection.}
}
}

\section{Usage}{

\code{x$print()}

\code{x$show()}

\code{x$repr()}

\code{x$ids()}

\code{x$length()}

\code{x$add}

\code{x$remove(id)}

\code{x$get_parameter(id)}

\code{x$set_parameter(id, value)}

\code{x$render_parameter(id)}

\code{x$render_all_parameters()}
}

\section{Arguments}{

\describe{

\item{id}{\code{id} object.}

\item{value}{any object.}

}
}

\section{Details}{


\describe{

\item{print}{print the object.}

\item{show}{show the object.}

\item{repr}{\code{character} representation of object.}

\item{ids}{\code{character} ids for objects inside collection.}

\item{length}{\code{integer} number of objects inside collection.}

\item{add}{add \linkS4class{ProjectModifier} object.}

\item{remove}{remove an item from the collection.}

\item{get_parameter}{retrieve the value of a parameter in the object
using an \code{id} object.}

\item{set_parameter}{change the value of a parameter in the object
to a new object.}

\item{render_parameter}{generate a \emph{shiny} widget to modify the
the value of a parameter (specified by argument \code{id}).}

\item{render_all_parameters}{generate a \code{\link[shiny:reexports]{shiny::div()}}
containing all the parameters" widgets.}

}
}

\seealso{
\linkS4class{Constraint}.
}
