% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gauss_newton.R
\name{gauss_newton}
\alias{gauss_newton}
\title{Gauss-Newton Optimization}
\usage{
gauss_newton(
  start,
  objective,
  residual = NULL,
  gradient = NULL,
  hessian = NULL,
  jac = NULL,
  lower = -Inf,
  upper = Inf,
  control = list(),
  ...
)
}
\arguments{
\item{start}{Numeric vector. Starting values for the optimization parameters.}

\item{objective}{Function. The objective function to minimize.}

\item{residual}{Function (optional). Function that returns the residuals vector.}

\item{gradient}{Function (optional). Gradient of the objective function.}

\item{hessian}{Function (optional). Hessian matrix of the objective function.}

\item{jac}{Function (optional). Jacobian matrix of the residuals.}

\item{lower}{Numeric vector. Lower bounds for box constraints.}

\item{upper}{Numeric vector. Upper bounds for box constraints.}

\item{control}{List. Control parameters including convergence flags:
\itemize{
  \item \code{use_abs_f}: Logical. Use absolute change in objective for convergence.
  \item \code{use_rel_f}: Logical. Use relative change in objective for convergence.
  \item \code{use_abs_x}: Logical. Use absolute change in parameters for convergence.
  \item \code{use_rel_x}: Logical. Use relative change in parameters for convergence.
  \item \code{use_grad}: Logical. Use gradient norm for convergence.
  \item \code{use_posdef}: Logical. Verify positive definiteness at convergence.
  \item \code{use_pred_f}: Logical. Record predicted objective decrease.
  \item \code{use_pred_f_avg}: Logical. Record average predicted decrease.
  \item \code{diff_method}: String. Method for numerical differentiation.
}}

\item{...}{Additional arguments passed to objective, gradient, and Hessian functions.}
}
\value{
A list containing optimization results and iteration metadata.
}
\description{
Implements a full-featured Gauss-Newton algorithm for non-linear optimization, 
specifically optimized for Structural Equation Modeling (SEM).
}
\details{
\code{gauss_newton} is a specialized optimization algorithm for least-squares 
and Maximum Likelihood problems where the objective function can be 
expressed as a sum of squared residuals.

\bold{Scaling and SEM Consistency:}
To ensure consistent simulation results and standard error (SE) calculations, 
this implementation adjusts the Gradient \eqn{(2J^T r)} and the Approximate 
Hessian \eqn{(2J^T J)} to match the scale of the Maximum Likelihood (ML) 
fitting function \eqn{F_{ML}}. This alignment is critical when calculating 
asymptotic covariance matrices using the formula \eqn{\frac{2}{n} H^{-1}}.

\bold{Comparison with Newton-Raphson:}
Unlike \code{newton_raphson} or \code{modified_newton}, which require the full 
second-order Hessian, Gauss-Newton approximates the Hessian using the 
Jacobian of the residuals. This is computationally more efficient and 
provides a naturally positive-semidefinite approximation, though a ridge 
adjustment is still provided for numerical stability.

\bold{Ridge Adjustment Strategy:}
The function includes a "Ridge Rescue" mechanism. If the approximate Hessian 
is singular or poorly conditioned for Cholesky decomposition, it iteratively 
adds a diagonal ridge \eqn{(\tau I)} until numerical stability is achieved.
}
\references{
\itemize{
   \item Nocedal, J., & Wright, S. J. (2006). \emph{Numerical Optimization}. Springer.
   \item Bollen, K. A. (1989). \emph{Structural Equations with Latent Variables}. Wiley.
}
}
