% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opusminer.R
\name{opus}
\alias{opus}
\title{Filtered Top-k Association Discovery of Self-Sufficient Itemsets}
\usage{
opus(transactions, k = 100, format = "data.frame", sep = " ",
  print_closures = FALSE, filter_itemsets = TRUE, search_by_lift = FALSE,
  correct_for_mult_compare = TRUE, redundancy_tests = TRUE)
}
\arguments{
\item{transactions}{A filename, list, or object of class
\code{\link[arules]{transactions}} (\code{arules}).}

\item{k}{The number of itemsets to return, an integer (default 100).}

\item{format}{The output format ("data.frame", default, or "itemsets").}

\item{sep}{The separator between items (for files, default " ").}

\item{print_closures}{return the closure for each itemset (default \code{FALSE})}

\item{filter_itemsets}{filter itemsets that are not independently productive (default \code{TRUE})}

\item{search_by_lift}{make lift (rather than leverage) the measure of interest (default \code{FALSE})}

\item{correct_for_mult_compare}{correct alpha for the size of the search space (default \code{TRUE})}

\item{redundancy_tests}{exclude redundant itemsets (default \code{TRUE})}
}
\value{
The top \emph{k} productive, non-redundant itemsets, with relevant
  statistics, in the form of a data frame, object of class
  \code{\link[arules]{itemsets}} (\code{arules}), or a list.
}
\description{
\code{opus} finds the top \emph{k} productive, non-redundant itemsets on the
measure of interest (leverage or lift) using the OPUS Miner algorithm.
}
\details{
\code{opus} provides an interface to the OPUS Miner algorithm (implemented in
C++) to find the top \emph{k} productive, non-redundant itemsets by leverage
(default) or lift.

\code{transactions} should be a filename, list (of transactions, each list
element being a vector of character values representing item labels), or an
object of class \code{\link[arules]{transactions}} (\code{arules}).

Files should be in the format of a list of transactions, one line per
transaction, each transaction (ie, line) being a sequence of item labels,
separated by the character specified by the parameter \code{sep} (default "
").  See, for example, the files at \url{http://fimi.ua.ac.be/data/}.
(Alternatively, files can be read seaparately using the
\code{\link{read_transactions}} function.)

\code{format} should be specified as either "data.frame" (the default) or
"itemsets", and any other value will return a list.
}
\examples{
\dontrun{

result <- opus("mushroom.dat")
result <- opus("mushroom.dat", k = 50)

result[result$self_sufficient, ]
result[order(result$count, decreasing = TRUE), ]

trans <- read_transactions("mushroom.dat", format = "transactions")

result <- opus(trans, print_closures = TRUE)
result <- opus(trans, format = "itemsets")
}
}
\references{
Webb, G. I., & Vreeken, J. (2014). Efficient Discovery of the Most
Interesting Associations. \emph{ACM Transactions on Knowledge Discovery from
Data}, 8(3), 1-15. doi: http://dx.doi.org/10.1145/2601433
}
