% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution.R
\name{rordbeta}
\alias{rordbeta}
\title{Generate Ordered Beta Variates}
\usage{
rordbeta(n = 100, mu = 0.5, phi = 1, cutpoints = c(-1, 1))
}
\arguments{
\item{n}{Number of variates to generate.}

\item{mu}{Value of the mean of the distribution.
Should be in the \(0,1\) interval (cannot be strictly equal to 0 or 1). If
length is greater than 1, should be of length \code{n}.}

\item{phi}{Value of the dispersion parameter. Should be strictly greater than 0. If
length is greater than 1, should be of length \code{n}.}

\item{cutpoints}{A vector of two numeric values for the cutpoints. Second value should
be strictly greater than the first value.}
}
\value{
A vector of length \code{n} of variates from the ordered beta distribution.
}
\description{
This function will generate ordered beta random variates given
values for the mean (\code{mu}), dispersion (\code{phi}) and cutpoints
governing the ratio of degenerate (discrete) to continuous
responses.
}
\examples{

# generate 100 random variates with an average of 0.7
# all will be in the closed interval \[0,1\]

ordbeta_var <- rordbeta(n=100, mu=0.7, phi=2)

# Will be approx mean = 0.7 with high positive skew

summary(ordbeta_var)
}
