% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-stats-prcomp.r
\name{methods-prcomp}
\alias{methods-prcomp}
\alias{as_tbl_ord.prcomp}
\alias{recover_rows.prcomp}
\alias{recover_cols.prcomp}
\alias{recover_inertia.prcomp}
\alias{recover_coord.prcomp}
\alias{recover_conference.prcomp}
\alias{recover_aug_rows.prcomp}
\alias{recover_aug_cols.prcomp}
\alias{recover_aug_coord.prcomp}
\title{Functionality for principal components analysis ('prcomp') objects}
\usage{
\method{as_tbl_ord}{prcomp}(x)

\method{recover_rows}{prcomp}(x)

\method{recover_cols}{prcomp}(x)

\method{recover_inertia}{prcomp}(x)

\method{recover_coord}{prcomp}(x)

\method{recover_conference}{prcomp}(x)

\method{recover_aug_rows}{prcomp}(x)

\method{recover_aug_cols}{prcomp}(x)

\method{recover_aug_coord}{prcomp}(x)
}
\arguments{
\item{x}{An ordination object.}
}
\value{
The recovery generics \verb{recover_*()} return \link[=recoverers]{core model components}, \link[=conference]{distribution of inertia},
\link[=supplementation]{supplementary elements}, and \link[=augmentation]{intrinsic metadata}; but they require methods for each model class to
tell them what these components are.

The generic \code{\link[=as_tbl_ord]{as_tbl_ord()}} returns its input wrapped in the 'tbl_ord'
class. Its methods determine what model classes it is allowed to wrap. It
then provides 'tbl_ord' methods with access to the recoverers and hence to
the model components.
}
\description{
These methods extract data from, and attribute new data to,
objects of class \code{"prcomp"} as returned by \code{\link[stats:prcomp]{stats::prcomp()}}.
}
\examples{
# data frame of Anderson iris species measurements
class(iris)
head(iris)

# compute scaled row-principal components of scaled measurements
iris[, -5] \%>\%
  prcomp(scale = TRUE) \%>\%
  as_tbl_ord() \%>\%
  print() -> iris_pca

# recover observation principal coordinates and measurement standard coordinates
head(get_rows(iris_pca))
get_cols(iris_pca)

# augment measurements with names and scaling parameters
(iris_pca <- augment_ord(iris_pca))
}
\seealso{
Other methods for singular value decomposition-based techniques: 
\code{\link{methods-cancor}},
\code{\link{methods-correspondence}},
\code{\link{methods-lda}},
\code{\link{methods-lra}},
\code{\link{methods-mca}},
\code{\link{methods-princomp}},
\code{\link{methods-svd}}
}
\author{
Emily Paul
}
\concept{methods for singular value decomposition-based techniques}
