% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/orientation.R
\name{swapDimension}
\alias{swapDimension}
\title{Reslice Data Volume Using DICOM Header Fields}
\usage{
swapDimension(img, dcm, digits = 2)
}
\arguments{
\item{img}{Multidimensional array (assumed to be three-dimensional only).}

\item{dcm}{DICOM header/image object associated with the multidimensional
array.}

\item{digits}{Number of significant digits used in testing
\code{unique}-ness of values in DICOM header fields.}
}
\value{
Multidimensional array with (potentially) permuted dimensions
because of the reslicing operation.  An additional attribute
\dQuote{\code{pixdim}} is provided in order to facilitate conversion from
DICOM to NIFTI/ANALYZE.
}
\description{
The input data volume (assumed to be three-dimensional) is re-sliced so that
each slice is in the axial plane.  Orientation is preserved so that
orthographic viewing is standardized.
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
\seealso{
\code{\link{dicom2nifti}}, \code{\link{getOrientation}}
}
\keyword{misc}

