% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ancillary.R
\name{mltree}
\alias{mltree}
\title{Build Up a ML Tree}
\usage{
mltree(msa, df = TRUE, gapl = TRUE, model = "WAG")
}
\arguments{
\item{msa}{input alignment.}

\item{df}{logical. When TRUE msa should be a dataframe, when FALSE msa should be a string giving the path to a fasta file containing the alignment.}

\item{gapl}{logical, when TRUE a gapless alignment is used.}

\item{model}{allows to choose an amino acid models (see the function phangorn::as.pml)}
}
\value{
a ML optimized tree (and parameters)
}
\description{
Given an alignment builds an ML tree.
}
\details{
The function makes a NJ tree and then improvove it using an optimization procedure based on ML.
}
\examples{
a <- msa(sequences=c("RAPGT", "KMPGT", "ESGGT"), ids = letters[1:3])$ali
rownames(a) <- letters[1:3]
tr <- mltree(a)$tree
}
\seealso{
gapless_msa
}
