% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.r
\name{predict}
\alias{predict}
\alias{predict.orthoDr}
\title{predict.orthoDr}
\usage{
\method{predict}{orthoDr}(object, testx, ...)
}
\arguments{
\item{object}{A fitted orthoDr object}

\item{testx}{Testing data}

\item{...}{...}
}
\value{
The predicted object
}
\description{
The prediction function for orthoDr fitted models
}
\examples{
# generate some survival data
N = 100; P = 4; dataX = matrix(rnorm(N*P), N, P)
Y = exp(-1 + dataX[,1] + rnorm(N))
Censor = rbinom(N, 1, 0.8)

# fit the model with keep.data = TRUE
orthoDr.fit = orthoDr_surv(dataX, Y, Censor, ndr = 1, method = "dm", keep.data = TRUE)

#predict 10 new observations
predict(orthoDr.fit, matrix(rnorm(10*P), 10, P))
}
