% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visu.R
\name{oscar.visu}
\alias{oscar.visu}
\title{Target function value and total kit cost as a function of number of kits included}
\usage{
oscar.visu(
  fit,
  y = c("target", "cost", "goodness", "cv", "AIC"),
  cols = c("red", "blue"),
  legend = "top",
  mtexts = TRUE,
  add = FALSE,
  main = ""
)
}
\arguments{
\item{fit}{Fitted oscar S4-class object}

\item{y}{Plotted y-axes supporting two simultaneous axes with different scales, Default: c("target", "cost", "goodness", "cv")}

\item{cols}{Colours for drawn lines, Default: c("red", "blue")}

\item{legend}{Location of legend or omission of legend with NA, Default: 'top'}

\item{mtexts}{Outer margin texts}

\item{add}{Should plot be added into an existing frame / plot}

\item{main}{Main title}
}
\value{
This is a plotting function that does not return anything, but instead draws on an existing or a new graphics device.
}
\description{
Plot oscar S4-object goodness-of-fit, kit costs, and similar performance metrics.
}
\examples{
if(interactive()){
  data(ex)
  fit <- oscar(x=ex_X, y=ex_Y, k=ex_K, w=ex_c, family='cox')
  oscar.visu(fit, y=c("target", "cost"))
}
}
