% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs.R
\name{get_crs}
\alias{get_crs}
\title{Convert the CRS to a URI.}
\usage{
get_crs(x, returnType = c("uri", "number", "code"))
}
\arguments{
\item{x}{(character or numeric)  The CRS for the, either in the format
"epsg:xxxx" or an EPSG number. e.g. British National Grid can be supplied
as "epsg:27700" or 27700. Available CRS values are: EPSG:27700, EPSG:4326,
EPSG:7405, EPSG:3857, and CRS84.}

\item{returnType}{(character) Should the URI to the CRS be returned
(\code{'uri'}), the EPSG number (\code{'number'}), or the string value
(\code{'code'})? The default is \code{'uri'}.}
}
\value{
Character string of a URI to the CRS specification.
}
\description{
Given possible user-inputs to specify a CRS, check validity and then convert
the CRS labels into a URI accepted by the OS Data Hub.
}
\keyword{internal}
