% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osf_retrieve.R
\name{osf_retrieve}
\alias{osf_retrieve}
\alias{osf_retrieve_user}
\alias{osf_retrieve_node}
\alias{osf_retrieve_file}
\title{Retrieve an entity from OSF}
\usage{
osf_retrieve_user(id)

osf_retrieve_node(id)

osf_retrieve_file(id)
}
\arguments{
\item{id}{An OSF identifier corresponding to an OSF user, project, component,
or file. Set \code{id = "me"} to retrieve your own OSF profile.}
}
\value{
An \code{\link{osf_tbl_user}}, \code{\link{osf_tbl_node}}, or \code{\link{osf_tbl_file}} containing
the corresponding OSF entity.
}
\description{
Create an \code{\link{osf_tbl}} representation of an existing OSF project, component,
file, or user based on the associated unique identifier. Usually this is a
5-character global unique identifier (GUID) but for files or directories, it
could also be an 11-character Waterbutler ID. See below for details.
}
\section{OSF identifiers}{
 A 5-character GUID is assigned to every user,
project, component, and file on OSF and forms the basis for the service's
URL scheme. For example the GUID for a project accessible at
\url{https://osf.io/ezum7} is simply \code{ezum7}. You can learn more about GUIDs
\href{https://help.osf.io/hc/en-us/articles/360019737894-FAQs}{here}.

An important detail is that files and directories are handled internally on
OSF by another serviced called \href{http://www.waterbutler.io/}{Waterbutler},
which uses 11-character identifiers. Although Waterbutler IDs are largely
hidden from users on \url{https://osf.io}, they represent the primary method for
identifying files/directories by the OSF API. In fact, files do not receive a
GUID until it is viewed directly on \url{https://osf.io} and directories never
receive a GUID. Therefore, osfr relies on Waterbutler IDs for files and
directories, and always includes them (rather than GUIDs) in \code{\link{osf_tbl_file}}
objects.
}

\section{Retrieving OSF objects}{

To begin using osfr to interact with resources on OSF you must use one of the
following \emph{retrieve} functions to create an \code{\link{osf_tbl}} that contains
the entity of interest. Note the functions are entity-type specific, use:
\itemize{
\item \code{osf_retrieve_node()} to retrieve a project or component
\item \code{osf_retrieve_file()} to retrieve a file or directory
\item \code{osf_retrieve_user()} to retrieve a user
}
}

\section{A note on 3rd-party storage providers}{

While OSF supports integration with a variety of 3rd-party cloud storage
providers, osfr can currently only access files stored on the default OSF
storage service. Support for additional storage providers is planned for a
future release.
}

\examples{
\dontrun{
 # retrieve your own OSF user profile (must be authenticated, ?osf_auth)
 osf_retrieve_user("me")

# retrieve the Psychology Reproducibility Project (P:RP, osf.io/ezum7)
osf_retrieve_node("ezum7")

# get the first figure from the P:RP
osf_retrieve_file("https://osf.io/7js8c")
}
}
