/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.osmose.output;

import fr.ird.osmose.School;
import fr.ird.osmose.output.AbstractDistribOutput;
import fr.ird.osmose.output.distribution.AbstractDistribution;
import java.io.File;

public class AbundanceDistribOutput
extends AbstractDistribOutput {
    public AbundanceDistribOutput(int rank, AbstractDistribution distrib) {
        super(rank, distrib);
    }

    @Override
    public void update() {
        for (School school : this.getSchoolSet().getAliveSchools()) {
            int classSchool = this.getClass(school);
            if (classSchool < 0) continue;
            double[] dArray = this.values[school.getSpeciesIndex()];
            int n = classSchool;
            dArray[n] = dArray[n] + school.getInstantaneousAbundance();
        }
    }

    @Override
    String getFilename() {
        StringBuilder filename = new StringBuilder(this.getType().toString());
        filename.append("Indicators");
        filename.append(File.separatorChar);
        filename.append(this.getConfiguration().getString("output.file.prefix"));
        filename.append("_abundanceDistribBy");
        filename.append(this.getType().toString());
        filename.append("_Simu");
        filename.append(this.getRank());
        filename.append(".csv");
        return filename.toString();
    }

    @Override
    String getDescription() {
        StringBuilder description = new StringBuilder();
        description.append("Distribution of fish abundance (number of fish) by ");
        description.append(this.getType().getDescription());
        description.append(". For class i, the number of fish in [i,i+1[ is reported.");
        return description.toString();
    }

    @Override
    public void initStep() {
    }
}

