% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation-helpers.R
\name{validateEnumValue}
\alias{validateEnumValue}
\title{Check if \code{value} is in the given \code{enum}. If not, stops with an error.}
\usage{
validateEnumValue(value, enum, nullAllowed = FALSE)
}
\arguments{
\item{value}{A value to search for in the \code{enum}.}

\item{enum}{\code{enum} where the \code{value} should be contained.}

\item{nullAllowed}{If \code{TRUE}, \code{value} can be \code{NULL} and the test always
passes. If \code{FALSE} (default), \code{NULL} is not accepted and the test fails.}
}
\description{
Check if \code{value} is in the given \code{enum}. If not, stops with an error.
}
\examples{
Symbol <- enum(c(Diamond = 1, Triangle = 2, Circle = 2))
validateEnumValue(1, Symbol)
}
