% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meter-provider-file.R
\docType{data}
\name{meter_provider_file}
\alias{meter_provider_file}
\title{Meter provider to collect metrics in JSONL files}
\value{
\code{meter_provider_file$new()} returns an \link[otel:otel_meter_provider]{otel::otel_meter_provider}
object.

\code{meter_provider_file$options()} returns a named list, the current
values of the options.
}
\description{
This is the \href{https://opentelemetry.io/docs/specs/otel/protocol/file-exporter/}{OTLP file exporter}.
It writes measurements to a JSONL file, each measurement is a line in
the file, a valid JSON value. The line separator is \verb{\\n}.
The preferred file extension is \code{jsonl}.

Select this tracer provider with \code{OTEL_METRICS_EXPORTER=otlp/file}.
}
\section{Usage}{
Externally:

\if{html}{\out{<div class="sourceCode">}}\preformatted{OTEL_METRICS_EXPORTER=otlp/file
}\if{html}{\out{</div>}}

From R:

\if{html}{\out{<div class="sourceCode">}}\preformatted{meter_provider_file$new(opts = NULL)
meter_provider_file$options()
}\if{html}{\out{</div>}}
}

\section{Arguments}{
\itemize{
\item \code{opts}: Named list of options. See below.
}
}

\section{Options}{
\subsection{File exporter options}{
\itemize{
\item \code{file_pattern}: Output file pattern. Value is set from:
\itemize{
\item \code{opts} argument, or
\item \code{OTEL_EXPORTER_OTLP_METRICS_FILE} environment variable, or
\item \code{OTEL_EXPORTER_OTLP_FILE} environment variable, or
\item the default is: \verb{metrics-\%N.jsonl}.
}

May contain placeholders, see below.
\item \code{alias_pattern}: The file which always point to the latest file.
Value is set from:
\itemize{
\item \code{opts} argument, or
\item \code{OTEL_EXPORTER_OTLP_METRICS_FILE_ALIAS} environment variable, or
\item \verb{OTEL_EXPORTER_OTLP_FILE_ALIAS environment variable}, or
\item the default is: \code{metrics-latest.jsonl}.
}

May contain placeholders, see below.
\item \code{flush_interval}: Interval to force flush output. A time interval
specification, see \link{Time Interval Options}. Value is set from
\itemize{
\item \code{opts} argument, or
\item \code{OTEL_EXPORTER_OTLP_METRICS_FILE_FLUSH_INTERVAL} environment variable, or
\item \code{OTEL_EXPORTER_OTLP_FILE_FLUSH_INTERVAL} environment variable, or
\item the default is \verb{30s}, thirty seconds.
}
\item \code{flush_count}: Force flush output after every \code{flush_count} records.
Value is set from
\itemize{
\item \code{opts} argument, or
\item \code{OTEL_EXPORTER_OTLP_METRICS_FILE_FLUSH_COUNT} environment variable, or
\item \code{OTEL_EXPORTER_OTLP_FILE_FLUSH_COUNT} environment variable, or
\item the default is \code{256}.
}
\item \code{file_size}: File size to rotate output files. A file size
specification, see \link{File Size Options}. Value is set from
\itemize{
\item \code{opts} argument, or
\item \code{OTEL_EXPORTER_OTLP_METRICS_FILE_FILE_SIZE} environment variable, or
\item \code{OTEL_EXPORTER_OTLP_FILE_FILE_SIZE} environment variable, or
\item the default is \verb{20MB}.
}
\item \code{rotate_size}: How many rotated output files to keep. Value is set
from
\itemize{
\item \code{opts} argument, or
\item \code{OTEL_EXPORTER_OTLP_METRICS_FILE_ROTATE_SIZE} environment variable, or
\item \code{OTEL_EXPORTER_OTLP_FILE_ROTATE_SIZE} environment variable, or
\item the default is \code{10}.
}
}

Special placeholders are available for \code{file_pattern} and
\code{alias_pattern}:
\itemize{
\item \verb{\%Y}: Writes year as a 4 digit decimal number.
\item \verb{\%y}: Writes last 2 digits of year as a decimal number (range \verb{[00,99]}).
\item \verb{\%m}: Writes month as a decimal number (range \verb{[01,12]}).
\item \verb{\%j}: Writes day of the year as a decimal number (range \verb{[001,366]}).
\item \verb{\%d}: Writes day of the month as a decimal number (range \verb{[01,31]}).
\item \verb{\%w}: Writes weekday as a decimal number, where Sunday is 0
(range \verb{[0-6]}).
\item \verb{\%H}: Writes hour as a decimal number, 24 hour clock (range \verb{[00-23]}).
\item \verb{\%I}: Writes hour as a decimal number, 12 hour clock (range \verb{[01,12]}).
\item \verb{\%M}: Writes minute as a decimal number (range \verb{[00,59]}).
\item \verb{\%S}: Writes second as a decimal number (range \verb{[00,60]}).
\item \verb{\%F}: Equivalent to \verb{\%Y-\%m-\%d} (the ISO 8601 date format).
\item \verb{\%T}: Equivalent to \verb{\%H:\%M:\%S} (the ISO 8601 time format).
\item \verb{\%R}: Equivalent to \verb{\%H:\%M}.
\item \verb{\%N}: Rotate index, start from 0.
\item \verb{\%n}: Rotate index, start from 1.
}
}

\subsection{Metric reader options}{
\itemize{
\item \code{export_interval}: the time interval between the
start of two export attempts, in milliseconds. Value is set from
\itemize{
\item the \code{opts} argument, or
\item the \code{OTEL_METRIC_EXPORT_INTERVAL} environment variable, or
\item the default is \code{60000}.
}
\item \code{export_timeout}: Maximum allowed time to export data, in
milliseconds. Value is set from
\itemize{
\item the \code{opts} argument, or
\item the \code{OTEL_METRIC_EXPORT_TIMEOUT} environment variable, or
\item the default is \code{30000}.
}
}
}
}

\examples{
meter_provider_file$options()
}
\keyword{datasets}
