% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetNumTrainingValues.R
\name{GetNumTrainingValues}
\alias{GetNumTrainingValues}
\title{Get Number of Training Values}
\usage{
GetNumTrainingValues(n.row, prob.percent = 0.15)
}
\arguments{
\item{n.row}{Number of rows of the all dataset with training and test values.}

\item{prob.percent}{Percentage of training values}
}
\value{
Number of training values.
}
\description{
\code{GetNumTrainingValues} Calculates the number of values to be used as a
training set.
}
\details{
the number of values to be used as a training set is calculated as a minimum
between 15\% of the number of rows in the dataset and 15\% of 5000.
}
\examples{
## Generate data
set.seed(100)
n <- 180
x <- sample(1:100, n, replace = TRUE)
x[70:90] <- sample(110:115, 21, replace = TRUE)
x[25] <- 200
x[150] <- 170
df <- data.frame(timestamp = 1:n, value = x)

# Get number of instances to train phase
GetNumTrainingValues(nrow(df))
}
\references{
A. Lavin and S. Ahmad, “Evaluating Real-time Anomaly Detection Algorithms – the
Numenta Anomaly Benchmark,” in 14th International Conference on Machine Learning and
Applications (IEEE ICMLA’15), 2015.
}
