% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numerical.R
\name{SummaryStats}
\alias{SummaryStats}
\title{Create summary statistics for a numerical variable}
\usage{
SummaryStats(myVar, dataFl, dateGp, weightNm = NULL)
}
\arguments{
\item{myVar}{The name of the variable to be plotted}

\item{dataFl}{A \code{data.table} of data; must be the output of the
\code{\link{PrepData}} function.}

\item{dateGp}{Name of the variable that the time series plots should be 
grouped by. Options are \code{NULL}, \code{"weeks"}, \code{"months"}, 
\code{"quarters"}, \code{"years"}. See \code{\link[data.table]{IDate}} for
details. If \code{NULL}, then \code{dateNm} will be used as \code{dateGp}.}

\item{weightNm}{Name of the variable containing row weights, or \code{NULL} for 
no weights (all rows receiving weight 1).}
}
\value{
\item{meltdx}{A \code{data.table} for use by the plotting funtions 
    \code{\link{PlotMean}}, \code{\link{PlotQuantiles}}, and 
    \code{\link{PlotRates}}.}
  \item{numVarSummary}{A \code{data.table} of summary statistics.}
}
\description{
Create summary statistics for a numerical variable
}
\section{License}{

Copyright 2017 Capital One Services, LLC Licensed under the Apache License,
Version 2.0 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the  License at
http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
or agreed to in writing, software distributed under the License is 
distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY 
KIND, either express or implied. See the License for the specific language 
governing permissions and limitations under the License.
}

\examples{
data(bankData)
bankData <- PrepData(bankData, dateNm = "date", dateGp = "quarters", 
                    dateGpBp = "years")
mdx <- SummaryStats(myVar = "age", dataFl = bankData, 
                   dateGp = "quarters")$meltdx
plot(PlotQuantiles(mdx[variable \%in\% c("p99", "p50", "p1", "p99_g", "p50_g",
                   "p1_g")], "age", "quarters"))
plot(PlotMean(mdx[variable \%in\% c("mean", "cl1", "cl2")], "age", "quarters"))
plot(PlotRates(mdx, "age", "quarters"))
}
