% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bankData}
\alias{bankData}
\title{Direct marketing campaigns of a Portuguese banking institution}
\format{A data frame with 45,211 rows and 19 variables:
\describe{
  \item{age}{Age of the client, numeric.}
  \item{job}{Type of job, a categorical variable with the levels: 
    \code{'admin.'}, \code{'blue-collar'}, \code{'entrepreneur'},
    \code{'housemaid'}, \code{'management'}, \code{'retired'},
    \code{'self-employed'}, \code{'services'}, \code{'student'},
    \code{'technician'}, \code{'unemployed'}, and \code{'unknown'}.}
  \item{marital}{Marital status, a categorical variable with levels: 
    \code{'divorced'}, \code{'married'}, \code{'single'}, and \code{'unknown'}.
    Note that \code{'divorced'} means either divorced or widowed.}
  \item{education}{A categorical variable with levels: \code{'basic.4y'},
    \code{'basic.6y'}, \code{'basic.9y'}, \code{'high.school'},
    \code{'illiterate'}, \code{'professional.course'}, 
    \code{'university.degree'}, and \code{'unknown'}.}
  \item{default}{Whether credit is in default, a categorical variable with 
    levels: \code{'no'}, \code{'yes'}, and \code{'unknown'}.}
  \item{balance}{Account balance, numeric.}
  \item{housing}{Whether the client has a housing loan, a categorical variable
    with levels: \code{'no'}, \code{'yes'}, and \code{'unknown'}.}
  \item{loan}{Whether the client has personal loan, a categorical variable
    with levels: \code{'no'}, \code{'yes'}, and \code{'unknown'}.}
  \item{contact}{Type of contact communication, a categorical variable
    with levels: \code{'cellular'} and \code{'telephone'}.}
  \item{duration}{Last contact duration in seconds, a numeric variable.}
  \item{campaign}{Number of contacts performed during this campaign for 
    this client, including the last contact; a numeric variable.}
  \item{pdays}{Number of days that passed by after the client was last 
    contacted from a previous campaign; a numeric variable, with \code{999} 
    means that client was not previously contacted.}
  \item{previous}{Number of contacts performed before this campaign for this
    client, a numeric variable.}
  \item{poutcome}{Outcome of the previous marketing campaign, a categorical
    variable with levels: \code{'failure'}, \code{'nonexistent'},
    and \code{'success'}.}
  \item{y}{Whether the client has subscribed a term deposit, a categorical
    variable with levels: \code{'yes'} and \code{'no'}.}
  \item{date}{Last contact date.}
}}
\source{
\url{https://archive.ics.uci.edu/ml/datasets/Bank+Marketing}

\cite{Lichman, M. (2013). UCI Machine Learning Repository 
  [\url{http://archive.ics.uci.edu/ml}]. Irvine, CA: University of California, 
  School of Information and Computer Science.}

\cite{S. Moro, P. Cortez, and P. Rita. (2014) A Data-Driven Approach
  to Predict the Success of Bank Telemarketing. Decision Support Systems, 
  Elsevier, 62:22-31, June 2014.}
}
\usage{
bankData
}
\description{
The marketing campaigns were based on phone calls.
Often, more than one contact to the same client was required, in order to 
access if the product (bank term deposit) would be ('yes') or not ('no') 
subscribed. Records are ordered by date (from May 2008 to November 2010), 
similar to data analyzed in Moro et al. [2014].
}
\keyword{datasets}
