% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outersupport.R
\name{BFGS_lpdf}
\alias{BFGS_lpdf}
\title{BFGS lpdf}
\usage{
BFGS_lpdf(
  om,
  logpdf,
  parlist = list(),
  newt = FALSE,
  cgsteps = 100,
  cgtol = 0.001,
  ...
)
}
\arguments{
\item{om}{an \code{\link{outermod}} instance}

\item{logpdf}{a \code{\link{lpdf}} instance}

\item{parlist}{an initial point, which are pulled from `om` and `logpdf` if 
not provided}

\item{newt}{boolean for if Newtons method should be used}

\item{cgsteps}{max number of cg iterations, if \code{newt=FALSE}}

\item{cgtol}{cg tolerance, if \code{newt=FALSE}}

\item{...}{additional parameters passed to \code{\link{BFGS_std}}}
}
\value{
a list of information from optimization.
}
\description{
A wrapper for code{\link{BFGS_std}} that is useful for easily calling 
parameter optimization for this package with as few lines as possible.
Note that \code{om} and \code{logpdf} will be set to optimal 
parameters, the return is simply for information.
}
