% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/open_curtain.R
\name{open_curtain}
\alias{open_curtain}
\title{Retrieve (Spatially Filtered) Overture Datasets}
\usage{
open_curtain(
  type,
  spatial_filter = NULL,
  theme = get_theme_from_type(type),
  conn = NULL,
  as_sf = FALSE,
  mode = "view",
  tablename = NULL,
  read_opts = list(),
  base_url = "s3://overturemaps-us-west-2/release/2024-08-20.0",
  bbox = NULL
)
}
\arguments{
\item{type}{A string specifying the type of overture dataset to read.
Setting to "*" or \code{NULL} will read all types for a given theme.}

\item{spatial_filter}{An object to spatially filter the result.}

\item{theme}{Inferred from type by default. Must be set if type is "*" or NULL}

\item{conn}{A connection to a duckdb database.}

\item{as_sf}{If TRUE, return an sf dataframe}

\item{mode}{Either "view" (default) or "table". If "table", will download the
dataset into memory.}

\item{tablename}{The name of the table to create in the database.}

\item{read_opts}{A named list of key-value pairs passed to
\href{https://duckdb.org/docs/data/parquet/overview.html#parameters}{DuckDB's read_parquet}}

\item{base_url}{Allows user to download data from a different mirror, such
as a local directory, or a alternative release.}

\item{bbox}{alias for \code{spatial_filter}. may be deprecated in the future.}
}
\value{
An dbplyr lazy dataframe, or an sf dataframe if as_sf is TRUE
}
\description{
Fetches overture data from AWS.
If a bounding box is provided, it applies spatial filtering to only include
records within that area. The core code is copied from \code{duckdbfs}, which
deserves all credit for the implementation
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bbox <- c(xmin = -120.5, ymin = 35.5, xmax = -120.0, ymax = 36.0)
open_curtain("building", bbox)
\dontshow{\}) # examplesIf}
}
