% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WCSCoverageDescription.R
\docType{class}
\name{WCSCoverageDescription}
\alias{WCSCoverageDescription}
\title{WCSCoverageDescription}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} modelling a WCS coverage summary
}
\description{
WCSCoverageDescription

WCSCoverageDescription
}
\note{
Class used internally by ows4R.
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Coverage}
\keyword{OGC}
\keyword{WCS}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:GMLAbstractObject]{geometa::GMLAbstractObject}} -> \code{\link[geometa:GMLAbstractFeature]{geometa::GMLAbstractFeature}} -> \code{\link[geometa:GMLAbstractCoverage]{geometa::GMLAbstractCoverage}} -> \code{\link[geometa:GMLCOVAbstractCoverage]{geometa::GMLCOVAbstractCoverage}} -> \code{WCSCoverageDescription}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{CoverageId}}{coverage ID}

\item{\code{SupportedCRS}}{supported CRS}

\item{\code{SupportedFormat}}{supported Format}

\item{\code{Domain}}{domain}

\item{\code{Range}}{range}

\item{\code{ServiceParameters}}{service parmaeters}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-WCSCoverageDescription-new}{\code{WCSCoverageDescription$new()}}
\item \href{#method-WCSCoverageDescription-getId}{\code{WCSCoverageDescription$getId()}}
\item \href{#method-WCSCoverageDescription-getSupportedCRS}{\code{WCSCoverageDescription$getSupportedCRS()}}
\item \href{#method-WCSCoverageDescription-getSupportedFormats}{\code{WCSCoverageDescription$getSupportedFormats()}}
\item \href{#method-WCSCoverageDescription-getDomain}{\code{WCSCoverageDescription$getDomain()}}
\item \href{#method-WCSCoverageDescription-getRange}{\code{WCSCoverageDescription$getRange()}}
\item \href{#method-WCSCoverageDescription-clone}{\code{WCSCoverageDescription$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="GMLAbstractFeature" data-id="setBoundedBy"><a href='../../geometa/html/GMLAbstractFeature.html#method-GMLAbstractFeature-setBoundedBy'><code>geometa::GMLAbstractFeature$setBoundedBy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="GMLAbstractCoverage" data-id="setDomainSet"><a href='../../geometa/html/GMLAbstractCoverage.html#method-GMLAbstractCoverage-setDomainSet'><code>geometa::GMLAbstractCoverage$setDomainSet()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="GMLAbstractCoverage" data-id="setRangeSet"><a href='../../geometa/html/GMLAbstractCoverage.html#method-GMLAbstractCoverage-setRangeSet'><code>geometa::GMLAbstractCoverage$setRangeSet()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageDescription-new"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageDescription-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{WCSCoverageDescription}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageDescription$new(xmlObj, serviceVersion, owsVersion, logger = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xmlObj}}{an object of class \link{XMLInternalNode-class} to initialize from XML}

\item{\code{serviceVersion}}{service version}

\item{\code{owsVersion}}{OWS version}

\item{\code{logger}}{logger}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageDescription-getId"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageDescription-getId}{}}}
\subsection{Method \code{getId()}}{
getId
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageDescription$getId()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
the coverage id, object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageDescription-getSupportedCRS"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageDescription-getSupportedCRS}{}}}
\subsection{Method \code{getSupportedCRS()}}{
getSupported CRS. Applies to WCS 1 coverage descriptions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageDescription$getSupportedCRS()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageDescription-getSupportedFormats"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageDescription-getSupportedFormats}{}}}
\subsection{Method \code{getSupportedFormats()}}{
get supported formats. Applies to WCS 1 coverage descriptions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageDescription$getSupportedFormats()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageDescription-getDomain"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageDescription-getDomain}{}}}
\subsection{Method \code{getDomain()}}{
get domain. Applies to WCS 1 coverage descriptions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageDescription$getDomain()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageDescription-getRange"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageDescription-getRange}{}}}
\subsection{Method \code{getRange()}}{
get range. Applies to WCS 1.0 coverage descriptions
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageDescription$getRange()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-WCSCoverageDescription-clone"></a>}}
\if{latex}{\out{\hypertarget{method-WCSCoverageDescription-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WCSCoverageDescription$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
