% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappingFunctions.R
\name{LD.getData}
\alias{LD.getData}
\title{Give back the data loaded into a dataLoader object}
\usage{
LD.getData(loader.obj)
}
\arguments{
\item{loader.obj}{a \code{dataLoader} object}
}
\value{
it returns a list contaning: \itemize{
\item{ \code{arrayAssociativo} the list of the possible EVENTS}
\item{ \code{footprint} the footprint table (with the BEGIN and END dummy states )}
\item{ \code{MMatrix} the transition matrix, filled with the absolute frequencies}
\item{ \code{MMatrix.perc} the transition matrix, filled with the relative frequencies (the rows are normalized to 1)'}
\item{ \code{MMatrix.perc.noLoop} the transition matrix, without auto-loop on the states, filled with the relative frequencies (the rows are normalized to 1)'}
\item{ \code{pat.processes} a list contaning the PROCESSES with all the other found in the csv}
\item{ \code{wordSequence.raw} a list contaning the just the PROCESSES}
}
}
\description{
This function wraps \code{dataLoader::getData() } method and returns the data previously loaded into a \code{dataLoader} object.
}
\examples{
\dontrun{ 

# Instantiate a'dataLoader' object
obj<- LD.builder()

# load a .csv
LD.load.csv(loader.obj = obj,nomeFile = "../csv/rectalCancer.csv",
   IDName = "ID_PATIENT",EVENTName = "EVNT")

# get back the loaded data
res<- LD.getData(loader.obj = obj)

# print the footprint Table
print(res$footPrint)
} 
}

