% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_partitionAroundMedoids.R
\name{cluster_partitionAroundMedoids}
\alias{cluster_partitionAroundMedoids}
\title{A class to perform Partition Around Medoids clustering on sequential data for Process Mining issues}
\usage{
cluster_partitionAroundMedoids()
}
\description{
This class performs sequence clustering on an event-log with the Partition Around Medoids (PAM) algorithm. The public methods are:
               \itemize{
               \item \code{cluster_partitionAroundMedoids() } is the constructor of the class
               \item \code{loadDataset( ...) } loads data taken from a \code{dataLoader::getData()} method, into a \code{cluster_partitionAroundMedoids()} object
               \item \code{calculateClusters() } performs the actual clustering computation on the previously loaded dataset
               \item \code{getClusters() } returns the clusters computed by the \code{cluster_partitionAroundMedoids::calculateClusters()} method
               \item \code{getClusterStats( ... )} returns informations about the clustering result (i.e. support, between-cluster distance, within-cluster mean distance and standard deviation)
               \item \code{getClusterLog( ... )} returns informations about the clustering computation itself (i.e. iterations needed to converge, centroids value after each iteration)
               }
               In order to better undestand the use of such methods, please visit: www.pminer.info

Parameters for \code{cluster_partitionAroundMedoids::calculateClusters()} method are:
  \itemize{
   \item \code{num } the number of clusters it has to generate
   \item \code{typeOfModel } the name of the Process Mining model it has to use to generate the space (up to now, only the default \code{"firstOrdermarkovModel"} is provided)
  }
}
\examples{
\dontrun{

# create a Loader 
obj.L<-dataLoader();   

# Load a .csv using "DES" and "ID" as column names to indicate events
# and Patient's ID
obj.L$load.csv(nomeFile = "../otherFiles/test_02.csv",
IDName = "ID",EVENTName = "DES",dateColumnName = "DATA")

# now create an object cluster_partitionAroundMedoids
obj.clPAM<- cluster_partitionAroundMedoids();

# load the data into logInspector object
obj.clPAM$loadDataset( obj.L$getData() );

# perform clustering computation
obj.clPAM$calculateClusters(num = 2);

# get calculated clusters
a <- obj.clPAM$getClusters();

# get informations about performance of clusters
b <- obj.clPAM$getClusterStats();

# get log of each iteration of the algorithm
d <- obj.clPAM$getClusterLog();
}
}

