% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2a_parameter_estimation_functions.R
\name{get_parameter_def_distribution}
\alias{get_parameter_def_distribution}
\title{Get the definition of given parameter distribution defined in a file}
\usage{
get_parameter_def_distribution(
  parameter,
  paramfile,
  colnames_paramdistr,
  strategycol = NA,
  strategyname = NA
)
}
\arguments{
\item{parameter}{parameter of interest}

\item{paramfile}{data file to be provided}

\item{colnames_paramdistr}{list of column names for the parameters that
define the distribution}

\item{strategycol}{treatment strategy column name}

\item{strategyname}{treatment strategy name in the column strategycol}
}
\value{
the definition of parameter from the given distribution
}
\description{
Get the definition of given parameter distribution defined in a file
}
\details{
This function reads the parameter distribution from a file and return the
parameter obtained
This assumes that the file contains parameter, distribution
colnames for parameter values for the distribution are passed on
to the function assumes the name of each parameter and value are given
in the consecutive columns. Once the expression is created using the
parameters given in the file, it gets checked for correctness of
specifying the distribution in R context using the function
check_estimate_substitute_proper_params and then evaluated.
}
\examples{
paramfile <- system.file("extdata", "table_param.csv",
package = "packDAMipd")
a <- get_parameter_def_distribution("rr", paramfile, c("Param1_name",
"Param1_value"))
}
