% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2a_parameter_estimation_functions.R
\name{use_generalised_linear_model}
\alias{use_generalised_linear_model}
\title{############################################################################
Get the parameter values using logistic regression}
\usage{
use_generalised_linear_model(
  param_to_be_estimated,
  dataset,
  indep_var,
  family,
  covariates,
  interaction,
  naaction,
  link = NA
)
}
\arguments{
\item{param_to_be_estimated}{parameter of interest}

\item{dataset}{data set to be provided}

\item{indep_var}{the independent variable (column name in data file)}

\item{family}{distribution name  eg. for logistic regression -binomial}

\item{covariates}{list of covariates-calculations to be done before passing}

\item{interaction}{boolean value to indicate interaction in the case of
linear regression}

\item{naaction}{action to be taken with the missing values}

\item{link}{link function if not the default for each family}
}
\value{
the results of the regression analysis
}
\description{
############################################################################
Get the parameter values using logistic regression
}
\details{
This function returns the results and plots after doing linear regression
Requires param to be estimated, dataset, independent variables and
information on covariates, and interaction variables if there are
Uses form_expression_glm to create the expression as per R standard for
e.g glm(y ~ x ). Returns the fit result,s summary results as returned by
summary(), confidence interval for
fit coefficients (ci_coeff), variance covariance matrix, cholesky
decomposition matrix, results from correlation test, plot of diagnostic
tests and model fit  assumptions, plot of model prediction
diagnostic include AIC, R2, and BIC. The results of the prediction
ie predicted values for fixed other variables will be returned in
prediction matrix
}
\examples{
\donttest{
gm_result <- use_generalised_linear_model(
  param_to_be_estimated = "Direction",
  dataset = ISLR::Smarket, indep_var = "Lag1", family = "binomial",
  covariates = c("Lag2", "Lag3"),
  interaction = FALSE, naaction = "na.omit", link = NA)
}
}
