% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rd_link.R
\name{rd_link}
\alias{rd_link}
\title{Translate a reference to a package function into a link to that function's documentation in rd.html}
\usage{
rd_link(txt, rd_html = rd_file_html(), pkg = ".")
}
\arguments{
\item{txt}{a string or expression referencing a function or other Rd object}

\item{rd_html}{the string to be used in the href string pointing to the page where Rd documentation is provided}

\item{pkg}{path to package being documented. Works when within sub-package directories}
}
\description{
This is meant to be used inside your packagedocs vignette docs.Rmd and rd.Rmd files
}
\details{
Instead of using \code{&#96;myfunction()&#96;} when talking about a package function \code{myfunction} inside your .Rmd file, you can use \code{&#96;r rd_link(myfunction())&#96;} or even things like \code{&#96;r rd_link(myfunction(arg1 = 1, ...))&#96;} and it will turn it into an href pointing to the online documentation of your package function \code{myfunction} in the page rendered by packagedocs.
}

