% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/snapshot.R
\name{.snapshotImpl}
\alias{.snapshotImpl}
\title{Internal Snapshot Implementation}
\usage{
.snapshotImpl(project, available = NULL, lib.loc = libDir(project),
  dry.run = FALSE, ignore.stale = FALSE, prompt = interactive(),
  auto.snapshot = FALSE, verbose = TRUE, fallback.ok = FALSE,
  snapshot.sources = TRUE)
}
\arguments{
\item{project}{The project directory. Defaults to current working
directory.}

\item{available}{A database of available packages.}

\item{lib.loc}{The library to snapshot. Defaults to the private library
associated with the given directory.}

\item{dry.run}{Computes the changes to your packrat state that would be made
if a snapshot were performed, and prints them to the console.}

\item{ignore.stale}{Stale packages are packages that are different from the
last snapshot, but were installed by packrat. Typically, packages become
stale when a new snapshot is available, but you haven't applied it yet with
\code{\link{restore}}. By default, packrat will prevent you from taking a
snapshot when you have stale packages to prevent you from losing changes
from the unapplied snapshot. If your intent is to overwrite the last
snapshot without applying it, use \code{ignore.stale = TRUE} to skip this
check.}

\item{prompt}{\code{TRUE} to prompt before performing snapshotting package
  changes that might be unintended; \code{FALSE} to perform these operations
  without confirmation. Potentially unintended changes include snapshotting
  packages at an older version than the last snapshot, or missing despite
  being present in the last snapshot.}

\item{auto.snapshot}{Internal use -- should be set to \code{TRUE} when this
is an automatic snapshot.}

\item{verbose}{Print output to the console while \code{snapshot}-ing?}

\item{fallback.ok}{Fall back to the latest CRAN version of a package if the
locally installed version is unavailable?}

\item{snapshot.sources}{Download the tarball associated with a particular
package?}
}
\description{
This is the internal implementation for \code{\link{snapshot}}. Most users
should prefer calling \code{\link{snapshot}}.
}
\keyword{internal}

