% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_load.R
\name{p_load}
\alias{p_load}
\title{Load One or More Packages}
\usage{
p_load(..., char, install = TRUE, update = getOption("pac_update"),
  character.only = FALSE)
}
\arguments{
\item{char}{Character vector containing packages to load.  If you are calling
\code{p_load} from within a function (or just having difficulties calling it 
using a character vector input) then pass your character vector of packages 
to load to this parameter directly.}

\item{install}{logical.  If \code{TRUE} will attempt to install a package not 
found in the library.}

\item{update}{logical.  If \code{TRUE} will attempt to update all out of date 
packages.  Default allows the user to set a \code{"pac_update"} in his/her 
.Rprofile.}

\item{character.only}{logical. If \code{TRUE} then \code{p_load} will only 
accept a single input which is a character vector containing the names of 
packages to load.}

\item{\ldots}{name(s) of package(s).}
}
\description{
This function is a wrapper for \code{\link[base]{library}} and 
\code{\link[base]{require}}.  It checks to see if a 
package is installed, if not it attempts to install the package from CRAN 
and/or any other repository in the \pkg{pacman} repository list.
}
\examples{
\dontrun{
p_load(lattice)
p_unload(lattice)
p_load(lattice, foreign, boot, rpart)
p_loaded()
p_unload(lattice, foreign, boot, rpart)
p_loaded()
}
}
\seealso{
\code{\link[base]{library}},
\code{\link[base]{require}},
\code{\link[utils]{install.packages}}
}
