% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{pac_validate}
\alias{pac_validate}
\title{Validate a specific local package}
\usage{
pac_validate(
  pac,
  lib.loc = .libPaths(),
  fields = c("Depends", "Imports", "LinkingTo"),
  lifeduration = FALSE,
  checkred = list(scope = character(0), flavors = NULL),
  repos = biocran_repos()
)
}
\arguments{
\item{pac}{character a package name.}

\item{lib.loc}{character vector. Default: \code{.libPaths()}}

\item{fields}{a character vector listing the types of dependencies, a subset of c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances").
Character string "all" is shorthand for that vector, character string "most" for the same vector without "Enhances", character string "strong" (default) for the first three elements of that vector.
Default: \code{c("Depends", "Imports", "LinkingTo")}}

\item{lifeduration}{logical if to add life duration column, might take some time. Default: FALSE}

\item{checkred}{list with two named fields, \code{scope} and \code{flavor}. \code{scope} of R CRAN check pages statuses to consider, any of \code{c("ERROR", "FAIL", "WARN", "NOTE")}. \code{flavor} vector of machines to consider, which might be retrieved with \code{pacs::cran_flavors()$Flavor}. By default an empty scope field deactivated assessment for \code{checkred} column, and NULL flavor will results in checking all machines. Default \code{list(scope = character(0), flavor = NULL)}}

\item{repos}{character vector base URLs of the repositories to use. By default checking CRAN and newest Bioconductor per R version. Default \code{pacs::biocran_repos()}}
}
\value{
data.frame with 5/7/8/9 columns.
\describe{
\item{Package}{character a package name.}
\item{Version.expected.min}{character expected by DESCRIPTION files minimal version. "" means not specified so the newest version.}
\item{Version.have}{character installed package version.}
\item{version_status}{ numeric -1/0/1 which comes from \code{utils::compareVersion} function.
0 means that we have the same version as required by DESCRIPTION files. -1 means we have too low version installed, this is an error. 1 means we have higher version.}
\item{direct}{ logical if the package is in the first depencency layer, direct depencencies from DESCRIPTION file.}
\item{newest}{ logical (Internet needed) if the installed version is the newest one.}
\item{cran}{logical (Internet needed) if the package is on CRAN, version is not taken into account here.}
\item{checkred}{(Optional) (Internet needed) logical if the NEWEST package contains any specified statuses on CRAN check page.}
\item{lifeduration}{(Optional) (Internet needed) integer number of days a package was released.}
}
}
\description{
Checking if installed package dependencies have correct versions taking into account their DESCRIPTION files requirements.
Moreover identifying which packages are newest releases.
Optionally we could add life duration and CRAN check page status for each dependency.
}
\note{
Version.expected.min column not count packages which are not a dependency for any package, so could not be find in DESCRIPTION files.
When turn on the \code{lifeduration} option, calculations might be time consuming.
Please as a courtesy to the R CRAN, don't overload their server by constantly using this function with \code{lifeduration} or \code{checkred} turned on.
Results are cached with \code{memoise} package, memory cache.
}
\examples{
\dontrun{
pac_validate("memoise")
pac_validate("memoise",
  lifeduration = TRUE,
  checkred = list(scope = c("ERROR", "FAIL"), flavors = NULL)
)
}
}
