% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lifeduration.R
\name{pac_lifeduration}
\alias{pac_lifeduration}
\title{Package version life duration at specific Date or for a specific version}
\usage{
pac_lifeduration(
  pac,
  version = NULL,
  at = NULL,
  lib.loc = .libPaths(),
  repos = biocran_repos(),
  source = c("crandb", "cran")
)
}
\arguments{
\item{pac}{character a package name.}

\item{version}{character package version, By default the newest version is taken.
The local repository has priority, it version is available. Default: NULL}

\item{at}{Date old version of package. Default: NULL}

\item{lib.loc}{character vector. Is omitted for non NULL version. Default: \code{.libPaths()}}

\item{repos}{character vector URLs of the repositories to use. By default checking CRAN and newest Bioconductor per R version. Default \code{pacs::biocran_repos()}}

\item{source}{character one of \code{c("crandb", "cran")}. Using the \verb{MEATCRAN  CRANDB} or the direct web page download from CRAN. Default: \code{"crandb"}}
}
\value{
\code{difftime}, number of days package version was the newest one.
}
\description{
a package life duration for a certain version or at a specific Date.
}
\note{
Results are cached for 30 minutes with \code{memoise} package.
The \code{crandb} R packages database is a part of \code{METACRAN} project, source:
Csárdi G, Salmon M (2022). \code{pkgsearch}: Search and Query CRAN R Packages. \verb{https://github.com/r-hub/pkgsearch}, \verb{https://r-hub.github.io/pkgsearch/}.
For \code{source = "cran"}the function will scrap two CRAN URLS. Works only with CRAN packages.
Please as a courtesy to the R CRAN, don't overload their servers by constantly using this function.
}
\examples{
\dontrun{
pacs::pac_lifeduration("memoise")
pacs::pac_lifeduration("memoise", source = "cran")
pacs::pac_lifeduration("dplyr", version = "0.8.0")
pacs::pac_lifeduration("dplyr", at = as.Date("2019-02-14"))
# For Bioconductor packages it will work only for the newest per R version and installed ones.
pacs::pac_lifeduration("S4Vectors")
}
}
