% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2dii.plot.R
\name{qplot_trajectory}
\alias{qplot_trajectory}
\title{Create a quick trajectory plot}
\usage{
qplot_trajectory(data)
}
\arguments{
\item{data}{A data frame like the outputs of \code{prep_trajectory()}.
\itemize{
\item (Optional) If present, the column \code{label} is used for data labels.
}}
}
\value{
An object of class "ggplot".
}
\description{
Compared to \code{\link[r2dii.plot:plot_trajectory]{plot_trajectory()}} this function:
\itemize{
\item is restricted to plotting only 5 years from the start year,
\item outputs pretty legend labels, based on the column holding metrics,
\item outputs a title,
\item outputs a subtitle,
\item outputs informative axis labels in sentence case.
}
}
\examples{
# `data` must meet documented "Requirements"
data <- subset(
  market_share,
  sector == "power" &
    technology == "renewablescap" &
    region == "global" &
    scenario_source == "demo_2020"
)

qplot_trajectory(data)
}
\seealso{
Other plotting functions: 
\code{\link{plot_emission_intensity}()},
\code{\link{plot_techmix}()},
\code{\link{plot_trajectory}()},
\code{\link{prep_emission_intensity}()},
\code{\link{prep_techmix}()},
\code{\link{prep_trajectory}()},
\code{\link{qplot_emission_intensity}()},
\code{\link{qplot_techmix}()},
\code{\link{recode_metric_techmix}()},
\code{\link{recode_metric_trajectory}()},
\code{\link{scale_colour_r2dii}()},
\code{\link{scale_colour_r2dii_sector}()},
\code{\link{scale_colour_r2dii_tech}()},
\code{\link{scale_fill_r2dii}()},
\code{\link{scale_fill_r2dii_sector}()},
\code{\link{scale_fill_r2dii_tech}()},
\code{\link{spell_out_technology}()},
\code{\link{theme_2dii}()},
\code{\link{to_title}()}
}
\concept{plotting functions}
