% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paleoDiv.R
\name{ab.gg}
\alias{ab.gg}
\title{Make a data.frame() that can be used to plot diversity data with density plots, e.g. in ggplot2}
\usage{
ab.gg(data, taxa = NULL, agerange = c(252, 66), precision_ma = 1)
}
\arguments{
\item{data}{list()-object containing occurrence data.frames or single occurrence data.frame()}

\item{taxa}{Selection of taxa to include. If NULL, then abundance is tabulated for each unique factor level of data$tna}

\item{agerange}{Range of geological ages to include in data.frame()}

\item{precision_ma}{Size of intervals (in ma) at which to calculate diversity within the age range.}
}
\value{
A data.frame() with two columns: ma, for the numerical age, and tax, for the taxon.
}
\description{
Make a data.frame() that can be used to plot diversity data with density plots, e.g. in ggplot2
}
\details{
Each taxon receives one entry per occurrence per time interval. The number of entries per taxon at any given point is thus proportional to the abundance of the taxon in the fossil record, and can be used for plotting with frequency- or density-based functions (e.g. hist(), ggplot2::geom_violin(), etc.). Note that using age values in the original occurrence table instead of this function will often be fully sufficient if the number of occurrences is considered an adequate proxy for abundance. However, instead using the ab.gg() and thus visualizing the results of the abdistr_() function has the benefit of the ability to account for a column of abundance values within the occurrence dataset, if available.
}
\examples{
pdb.autodiv(c("Coelophysoidea","Stegosauria"))->occ
ab.gg(data=occ, taxa=c("Coelophysoidea","Stegosauria"), agerange=c(252,0),precision_ma=1)->dino
library(ggplot2)
ggplot(data=dino, aes(x=tax, y=ma, col=tax))+ylim(252,0)+geom_violin(scale="count")
}
