% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2_scales_discrete.R
\name{scale_colour_paletteer_d}
\alias{scale_colour_paletteer_d}
\alias{scale_color_paletteer_d}
\alias{scale_fill_paletteer_d}
\title{Discrete scales to use for ggplot2}
\usage{
scale_colour_paletteer_d(package, palette, direction = 1, dynamic = FALSE,
  ...)

scale_color_paletteer_d(package, palette, direction = 1, dynamic = FALSE,
  ...)

scale_fill_paletteer_d(package, palette, direction = 1, dynamic = FALSE,
  ...)
}
\arguments{
\item{package}{Name of package from which the palette is desired as string
or symbol.}

\item{palette}{Name of palette as string or symbol.}

\item{direction}{Either \code{1} or \code{-1}. If \code{-1} the palette will be reversed.}

\item{dynamic}{toggles between the discrete palettes and the dynamic
palettes. Defaults to FALSE which indicates discrete palettes.}

\item{...}{additional arguments to pass to discrete_scale}
}
\description{
These functions provide the option to use the discrete and dynamic palettes
along with the \code{ggplot2} package. It goes without saying that it requires
\code{ggplot2} to work.
}
\details{
Available package/palette combinations are available in the data.frame
\code{\link[paletteer]{palettes_d_names}} and
\code{\link[paletteer]{palettes_dynamic_names}}. Both \code{package} and
\code{palette} can be supplied as symbols or strings.
}
\examples{

if (require('ggplot2')) {

  ggplot(iris, aes(x = Sepal.Length, y = Sepal.Width, colour = Species)) +
    geom_point() +
    scale_colour_paletteer_d(package = "nord", palette = "frost")
}

}
