% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval-information.R
\name{riskset_info}
\alias{riskset_info}
\title{Extract risk set information for each interval.}
\usage{
riskset_info(ped)
}
\arguments{
\item{ped}{An object of class \code{ped} as returned by
\code{\link[pammtools]{as_ped}}.}
}
\value{
A data frame with one row for each interval in \code{ped}.
}
\description{
The columns \code{ped_riskset, ped_events, ped_censored} provide the
size of the risk set at the beginning of each interval as well as the number
of events and censorings that occurred in the interval, respectively.
}
\examples{
ped <- tumor[1:4,] \%>\% as_ped(Surv(days, status)~ .)
riskset_info(ped)
}
\seealso{
\code{\link[pammtools]{int_info}}, \code{\link[pammtools]{sample_info}}
}
